
	
	// Filter 70s
__kernel void filter_70s(__read_only image2d_t image,   	// image buffer
						 __write_only image2d_t retImage,   // image buffer 3 for result	
						 __constant uchar* red,	  			// read only, red array 
						 __constant uchar* green, 			// read only, green array
						 __constant uchar* blue,  			// read only, blue array 
						 __private int alpha)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	
	if(w >= width || h >= height)
			return;
	float4 color = read_imagef(image, sampler, (int2)(w, h));
	uchar r = (uchar)(color.x * 255.0f);
	uchar g = (uchar)(color.y * 255.0f);
	uchar b = (uchar)(color.z * 255.0f);
	uchar a = (uchar)(color.w * 255.0f);
	
	float factor = (float)(alpha)/100.0f;
	float rt = ((float)(r) * (1.0f - factor) + (float)(red[r]) * factor) / 255.0f;
	float gt = ((float)(g) * (1.0f - factor) + (float)(green[g]) * factor) / 255.0f;
	float bt = ((float)(b) * (1.0f - factor) + (float)(blue[b]) * factor) / 255.0f;
	
	float4 retColor = (float4)(rt, gt, bt, a);
	
	//write_imagef(retImage, (int2)(w, h), retColor);
}						

// Filter Ash
__kernel void filter_Ash(__read_only image2d_t image1,   	// image buffer 1
						 __read_only image2d_t image2,   	// image buffer 2
						 __write_only image2d_t retImage,   // image buffer for result
						 __private int alpha)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image1);
	int height = get_image_height(image1);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	
	float2 uv = (float2)((float)w / width, (float)h / height);
	float4 textureColor = read_imagef(image1, sampler, uv);
	
	float blueColor = textureColor.z * 63.0f;
	
	float2 quad1;
	quad1.y = floor(floor(blueColor) / 8.0f);
	quad1.x = floor(blueColor) - quad1.y * 8.0f;
	
	float2 quad2;
	quad2.y = floor(ceil(blueColor) / 8.0f);
	quad2.x = ceil(blueColor) - (quad2.y * 8.0f);
	
	float2 texPos1;
	texPos1.x = (quad1.x * 0.125f) + 0.5f/512.0f + ((0.125f - 1.0f/512.0f) * textureColor.x);
	texPos1.y = (quad1.y * 0.125f) + 0.5f/512.0f + ((0.125f - 1.0f/512.0f) * textureColor.y);
	 
	float2 texPos2;
	texPos2.x = (quad2.x * 0.125f) + 0.5f/512.0f + ((0.125f - 1.0f/512.0f) * textureColor.x);
	texPos2.y = (quad2.y * 0.125f) + 0.5f/512.0f + ((0.125f - 1.0f/512.0f) * textureColor.y);
	
	uv = (float2)(texPos1.x, 1.0f - texPos1.y);
	float4 newColor1 = read_imagef(image2, sampler, uv);
	// translate newColor1 to bgra
	
	uv = (float2)(texPos2.x, 1.0f - texPos2.y);
	float4 newColor2 = read_imagef(image2, sampler, uv);
	
	float f = blueColor - floor(blueColor);
	float4 newColor = newColor1 * (1.0f - f) + newColor2 * f;		

	float factor = (float)(alpha)/100.0f;
	float4 color = ((float4)(newColor.xyz, textureColor.w)) * factor + textureColor * (1.0f - factor);	//bgra	
	
	write_imagef(retImage, (int2)(w, h), color);

}







